/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.breakpoint;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org2.eclipse.php.internal.debug.ui.PHPDebugUIImages;

public class PHPBreakpointImageDescriptor
extends CompositeImageDescriptor {
    public static final int ENABLED = 32;
    public static final int CONDITIONAL = 64;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;

    public PHPBreakpointImageDescriptor(ImageDescriptor baseImage, int flags) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PHPBreakpointImageDescriptor)) {
            return false;
        }
        PHPBreakpointImageDescriptor other = (PHPBreakpointImageDescriptor)((Object)object);
        return this.getBaseImage().equals(other.getBaseImage()) && this.getFlags() == other.getFlags();
    }

    public int hashCode() {
        return this.getBaseImage().hashCode() | this.getFlags();
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getBaseImage().getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays();
    }

    private void drawOverlays() {
        int flags = this.getFlags();
        int x = 0;
        int y = 0;
        ImageData data = null;
        if ((flags & 0x40) != 0) {
            data = (flags & 0x20) != 0 ? this.getImageData("IMG_OBJS_CONDITIONAL_BREAKPOINT") : this.getImageData("IMG_OBJS_CONDITIONAL_BREAKPOINT_DISABLED");
            x = 0;
            y = 0;
            this.drawImage(data, x, y);
        }
    }

    private ImageData getImageData(String imageDescriptorKey) {
        return PHPDebugUIImages.getImageDescriptor(imageDescriptorKey).getImageData();
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.getBaseImage().getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.fSize;
    }

    protected ImageDescriptor getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(ImageDescriptor baseImage) {
        this.fBaseImage = baseImage;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int flags) {
        this.fFlags = flags;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }
}

